***********************************************************
* This dofile was written to accompany the paper:
* Andrew Leigh & Alberto Posso, "Top Incomes and National Savings"
* (2009) Review of Income and Wealth, 55(1): 57-74
* 
* Feel free to adapt the dofile for your own purposes, but please cite that paper
* and Taylor (2002), if you use the historical savings data.
*
* Note that this zipfile does not include the Dimson data, since we do not have permission to distribute it.
*
* Questions? Contact andrew_leigh@ksg02.harvard.edu.
***********************************************************

* List of country codes used by Taylor for savings data
*  (1  arg   argentina)	
*  2  aus   australia	
*  5  can   canada	
*  7  dnk   denmark	
* ( 8  fin   finland)	
*  9  fra   france	
* 10  deu   germany	
*( 12  ita   italy)	
* 13  jpn   japan	
* 15  nld   netherlands	
* (17  nor   norway)	
* 19  esp   spain	
* (20  swe   sweden)	
* 22  gbr   united kingdom	
* 23  usa   united states	

clear
set more off

* Set directory 
cd "C:\Users\Andrew\My publications\Top Incomes & Savings\"

* Setting up top incomes data
use top10share, clear
for any australia canada france germany ireland netherlands newzealand spain sweden switzerland uk us: ren X s10X
reshape long s10,i(year) j(country) str
replace country="New Zealand" if country=="newzealand"
replace country=proper(country)
replace country=upper(country) if country=="Uk" | country=="Us"
la var s10 "Top 10% Share"
sort country year
save temp_s10, replace
use top1share, clear
for any australia canada france germany ireland japan netherlands newzealand spain sweden switzerland uk us: ren X s1X
reshape long s1,i(year) j(country) str
replace country="New Zealand" if country=="newzealand"
replace country=proper(country)
replace country=upper(country) if country=="Uk" | country=="Us"
la var s1 "Top 1% Share"
sort country year
save temp_s1, replace

* Setting up GDP data
use maddison_gdp, clear
renpfix _ gdp
reshape long gdp,i(country) j(year)
replace gdp=ln(gdp)
replace country="US" if country=="United States"
replace country="UK" if country=="United Kingdom"
la var gdp "Log GDP per capita (1990 US dollars)"
sort country year
save temp_gdp, replace

* Setting up interest rate data
use dimson_data_raw_pt1, clear
gen year=_n+1899
sort date
merge date using dimson_data_raw_pt2
drop _merge
keep *realbondstrt* year
renpfix dmsglobal
for any australia canada france germany ireland japan netherlands spain sweden switzerland uk us: ren X bondsX
keep year bonds*
reshape long bonds, i(year) j(country) str
replace country=proper(country)
replace country=upper(country) if country=="Uk" | country=="Us"
la var bonds "Total return on bonds in local currency (%)"
sort country year
save temp_dimson, replace

* Setting up dependency ratios
use dependency_ratios, clear
replace country="US" if country=="USA"
ren dependencyratio dep_rat
bysort country: ipolate dep_rat year, gen(temp)
replace dep_rat=temp if dep_rat==.
drop temp
replace dep_rat=.45 if country=="Germany" & year<=1955
replace dep_rat=.66 if country=="Japan" & year<=1946
replace dep_rat=.52 if country=="US" & year<=1932
la var dep_rat "Pop0-14 + PopOver65 / Pop15-64" 
sort country year
save temp_dependency_ratio, replace

* Setting up Taylor savings data
use savings_rates.dta, clear
strparse country_year, gen(countrycode) parse(//)
strparse countrycode2, gen(year) parse(:)
for any countrycode year: drop X2 \ ren X1 X \ destring X, force replace
gen str country=""
for num 2 5 9 10 13 15 19 20 22 23 \ any Australia Canada France Germany Japan Netherlands Spain Sweden UK US:  replace country="Y" if countrycode==X
drop countrycode country_year
ren savings_rate sav
drop if year>=1986
sort country year
save temp_taylor_savings, replace

* Setting up Domestic credit data
use domestic_credit, clear
for any france_francs germany_dm netherlands_guild spain_pese \ any france germany netherlands spain \ num 6.559 1.955 2.204 166.386: gen Y=Y_euro \ replace Y=X/Z if Y==. \ drop X Y_euro
for any france germany spain: replace X=X/1000 if year>=1999
for any france netherlands: ipolate X year, gen(temp) \ replace X=temp if X==. \ drop temp
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us: ren X dcX
reshape long dc,i(year) j(country) str
replace country="New Zealand" if country=="nz"
replace country=proper(country)
replace country=upper(country) if country=="Uk" | country=="Us"
la var dc "Domestic credit (NCU)"
sort country year
save temp_domestic_credit, replace

* Setting up GDP in NCU (for calculating domestic credit ratio)
use gdp_ncu, clear
for any australia canada france germany ireland netherlands spain sweden switzerland uk us: ren X gdp_ncuX
reshape long gdp_ncu,i(year) j(country) str
replace country=proper(country)
replace country=upper(country) if country=="Uk" | country=="Us"
la var gdp_ncu "GDP (NCU)"
sort country year
save temp_gdp_ncu, replace
merge country year using temp_domestic_credit
for any Canada France Germany Netherlands Spain Sweden Switzerland UK US: replace dc=dc*1000 if country=="X"
gen dc_gdp=dc/gdp_ncu
egen countryid=group(country)
tsset countryid year
replace dc_gdp=l.dc_gdp if dc_gdp==.
for num 1/15: replace dc_gdp=f.dc_gdp if dc_gdp==. & year~=X
drop countryid dc gdp_ncu _merge
tabstat dc_gdp,by(country) stat(mean min max n)
la var dc_gdp "Domestic Credit / GDP"
sort country year
save temp_dc_gdp, replace

* Setting up pension data
use pension_data, clear
keep if country=="Australia" | country=="Canada" | country=="France" | country=="Germany" | country=="Ireland" | country=="Netherlands" | country=="Spain" | country=="Sweden" | country=="Switzerland" | country=="UK" | country=="US"
for any sup cont: gen X2005=. \ gen X1945=.
reshape long sup cont,i(country) j(year) 
la var sup "Support ratio"
la var cont "Contribution rate"
egen countryid=group(country)
tsset countryid year
tsfill
replace country=country[_n-1] if country==""
for any sup cont: bysort country: ipolate X year, gen(temp) \ replace X=temp if X==. \ drop temp 
tsset countryid year
for any sup cont: replace X=l.X if X==.
for num 1/15: replace sup=f.sup if sup==. & year~=X \ replace cont=f.cont if cont==. & year~=X
drop countryid
sort country year
save temp_pensions_data, replace

* Setting up household savings data (1986-2002)
use household_savings_1986, clear
replace country="UK" if country=="United Kingdom"
replace country="US" if country=="United States"
keep if country=="Australia" | country=="Canada" | country=="France" | country=="Germany" | country=="Ireland" | country=="Netherlands" | country=="Spain" | country=="Sweden" | country=="Switzerland" | country=="UK" | country=="US"
reshape long hsav,i(country) j(year) 
la var hsav "Household savings rate"
replace hsav=hsav/100
sort country year
save temp_household_savings1, replace

* Setting up household savings data (1975-85)
* This approach sets savings figures to be the same in 1985 and 1986.
use household_savings_1975, clear
keep if country=="Australia" | country=="Canada" | country=="France" | country=="Germany" | country=="Ireland" | country=="Netherlands" | country=="Spain" | country=="Sweden" | country=="Switzerland" | country=="UK" | country=="US"
reshape long hsav,i(country) j(year) 
la var hsav "Household savings rate"
replace hsav=hsav/100
sort country year
merge country year using temp_household_savings1, 
for any 1985 1986: gen temp=hsav if year==X \ bysort country: egen tempX=max(temp) \ drop temp
gen diff=temp1986-temp1985
replace hsav=hsav+diff if year<=1985
drop _merge diff
sort country year
bysort country: list year hsav if year>=1984 & year<=1988
sort country year
save temp_household_savings2, replace

* Setting up LIS data (downloaded 22 June 2007)
use lis_june2007, clear
gen year=.
for num 1960/2010: replace year=X if strpos(dataset_s,"X")~=0
gen str country=""
for any Australia Canada France Germany Ireland Netherlands "New Zealand" Spain Sweden Switzerland "United Kingdom" "United States": replace country="X" if strpos(dataset_s,"X")~=0
keep if country~=""
* Delete second France 1984 observation
drop if dataset=="France (Tax) 1984 - LIS - wave2"
ren gini_coefficient lis_gini
gen lis_5010=percentile_ratio__90_10_/percentile_ratio__90_50_
gen lis_9050=percentile_ratio__90_50_
egen countryid=group(country)
tsset countryid year
tsfill
replace country=country[_n-1] if country==""
*Fill in missing observations using following criteria: {1st lag, 1st lead, 2nd lag, 2nd lead, 3rd lag, 3rd lead)
for any lis_gini lis_5010 lis_9050: gen Xnm=1 if X~=. \ replace X=l.X if X==. & l.Xnm==1 \ replace X=f.X if X==. & f.Xnm==1 \ replace X=l2.X if X==. & l2.Xnm==1 \ replace X=f2.X if X==. & f2.Xnm==1 \ replace X=l3.X if X==. & l3.Xnm==1 \ replace X=f3.X if X==. & f3.Xnm==1 \ drop Xnm
keep lis* country year
drop if country=="" | year==.
replace country="US" if country=="United States"
replace country="UK" if country=="United Kingdom"
sort country year
save temp_lis, replace

* Setting up OECD savings data
use oecd_savings_rates, clear
reshape long sav,i(country) j(year)
replace country="US" if country=="United States"
replace country="UK" if country=="United Kingdom"
replace sav=sav/100

* Merging datasets
sort country year
merge country year using temp_taylor_savings, update
drop _merge
for any s10 s1 gdp dimson dependency_ratio dc_gdp pensions_data household_savings2 lis: sort country year \ merge country year using temp_X, nokeep update \ tab _merge \ drop _merge
for any s10 s1 bonds cont: replace X=X/100
sort country
merge country using country_codes, nokeep
replace countrycode="USA" if country=="US"
replace countrycode="GBR" if country=="UK"
drop _merge

* Drop pre-1920 data
drop if year<1920

* Drop Japan
drop if country=="Japan" | country=="New Zealand"

* Drop if bond return missing
drop if bonds==.


/*
* Drawing graphs
set scheme s1mono
* Change from c.1960 to c.2000
gen temp1=abs(year-1960.1) if sav~=. & s1~=.
bysort country: egen temp2=min(temp1)
gen about1960=1 if temp2==temp1 & temp1<6
gen temp3=abs(year-2000.1) if sav~=. & s1~=.
bysort country: egen temp4=min(temp3)
gen about2000=1 if temp4==temp3 & temp3<6
drop temp*
* 1960ish to 2000ish
for any sav s10 s1: gen temp1=X if about1960==1 \ bysort country: egen temp2=max(temp1) \ gen dX=X-temp2 if about2000==1 \ drop temp*
*WITH LFIT: for any 10 1: tw scatter dsav dsX, mlabel(countrycode) || lfit dsav dsX, legend(off) xti("Change in Top Income Share") yti("Change in Savings Rate") ti("Top X% Share") name(sX, replace) nodraw
for any 10 1: tw scatter dsav dsX, mlabel(countrycode) legend(off) xti("Change in Top Income Share") yti("Change in Savings Rate") ti("Top X% Share") name(sX, replace) nodraw
gr combine s10 s1, ti("Figure 3: Changes in Top Incomes and Changes in Savings Rates") subti("From circa 1960 to circa 2000")
* 1986 to 2000ish
for any sav s10 s1: gen temp1=X if year==1986 \ bysort country: egen temp2=max(temp1) \ replace dX=X-temp2 if about2000==1 \ drop temp*
for any 10 1: tw scatter dsav dsX, mlabel(countrycode) || lfit dsav dsX, legend(off) xti("Change in Top Income Share") yti("Change in Savings Rate") ti("Top X% Share") name(sX, replace) nodraw
gr combine s10 s1, ti("Changes in Top Incomes and Savings Rates") subti("From 1986 to circa 2000")
sort country year
for any Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland UK US \ any Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland "U.K." "U.S.": tw line sav year if country=="X" & s1~=.,yaxis(1) yti("Savings Rate",axis(1)) ylab(#3,axis(1)) lpattern(solid) || line s1 year if country=="X" & sav~=., lpattern(dash) yaxis(2) yti("Top Income Share",axis(2)) ylab(#3,axis(2)) xti("") ti("Y") name(X, replace) nodraw legend(off)
gr combine Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland UK US, ti("Figure 2: Savings (left axis, solid line) and" "the Top 1% Share (right axis, dashed line)") ycommon xcommon
gr export fig2.wmf,replace
gr export fig2.eps,replace
gr save fig2.gph,replace
for any Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland UK US \ any Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland "U.K." "U.S.": tw line sav year if country=="X" & s10~=.,yaxis(1) yti("Savings Rate",axis(1)) ylab(#3,axis(1)) lpattern(solid) || line s10 year if country=="X" & sav~=., lpattern(dash) yaxis(2) yti("Top Income Share",axis(2)) ylab(#3,axis(2)) xti("") ti("Y") name(X, replace) nodraw legend(off)
gr combine Australia Canada France Germany Ireland Netherlands Spain Sweden Switzerland UK US, ti("Figure 1: Savings (left axis, solid line) and" "the Top 10% Share (right axis, dashed line)") ycommon xcommon
gr export fig1.wmf,replace
gr export fig1.eps,replace
gr save fig1.gph,replace
*/

* Running regressions
egen countryid=group(country)
tsset countryid year

* Using 5 or 10 year blocks
gen sav_5yr=sav if year/5==int(year/5)
gen sav_10yr=sav if year/10==int(year/10)

* Summary statistics
for any 10 1: xi: areg sav l.sX gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ sum sav l.sX gdp dep_rat bonds if e(sample) \ lincom gdp+l.gdp \ lincom dep_rat+l.dep_rat \ lincom bonds+l.bonds
for any 10 1: xi: areg sav_5yr l5.sX gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid, a(year) r cl(countryid) \ sum sav_5yr l5.sX gdp dep_rat bonds if e(sample) \ lincom gdp+l5.gdp \ lincom dep_rat+l5.dep_rat \ lincom bonds+l5.bonds
xi: areg sav l.s10 gdp l.gdp dep_rat l.dep_rat i.countryid, a(year) r cl(countryid)
sum year if e(sample)
xi: areg sav l.s1 gdp l.gdp dep_rat l.dep_rat i.countryid, a(year) r cl(countryid)
sum year if e(sample)
tabstat year if e(sample), stat(min max) by(country)
sum sav l.s1 l.s10 gdp dep_rat bonds dc_gdp sup cont hsav lis_5010 lis_9050 if e(sample),sep(0)
sum sav l.s10 if l.s10~=. & e(sample)

* Regressions
* OLS (Panel A)
gen top=l.s10
la var top "TopShare"
reg sav top gdp l.gdp dep_rat l.dep_rat , r cl(countryid)
outreg using results.doc, coefastr bracket 3aster replace bdec(3) se ct("S10 - annual (OLS)")
for any 1: replace top=l.sX \ reg sav top gdp l.gdp dep_rat l.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual (OLS)")
for any 10 1: replace top=l5.sX \ reg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks (OLS)")
for any 10 1: replace top=l10.sX \ reg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks (OLS)")

* FE (Panel B)
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks")

* Controlling for return on bonds (Panel C)
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. Bond control.")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. Bond control.")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. Bond control.")

* Post-1960 only
for any 10 1: replace top=l.sX \ reg sav top gdp l.gdp dep_rat l.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual 1960+ (OLS)")
for any 10 1: replace top=l5.sX \ reg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks 1960+ (OLS)")
for any 10 1: replace top=l10.sX \ reg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks 1960+ (OLS)")
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. 1960+")
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. Bond control. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. Bond control. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. Bond control. 1960+")

* Robustness checks
* Adding ineq-sq
gen topsq=.
for any 10 1: replace top=l.sX \ replace topsq=(l.sX)^2 \ xi: areg sav top topsq gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. Bond control. 1960+")
for any 10 1: replace top=l5.sX \ replace topsq=(l5.sX)^2 \ xi: areg sav_5yr top topsq gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. Bond control. 1960+")
for any 10 1: replace top=l10.sX \ replace topsq=(l10.sX)^2 \ xi: areg sav_10yr top topsq gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. Bond control. 1960+")
* Controlling for Domestic Credit/GDP
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds dc_gdp l.dc_gdp i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. DC & Bond control. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds dc_gdp l5.dc_gdp i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. DC & Bond control. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds dc_gdp l10.dc_gdp i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. DC & Bond control. 1960+")
* Controlling for pensions variables
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds sup l.sup cont l.cont i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - annual. Pension & Bond control. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds sup l5.sup cont l5.cont i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 5 year blocks. Pension & Bond control. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds sup l10.sup cont l10.cont i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - 10 year blocks. Pension & Bond control. 1960+")

* Using household savings rate
gen hsav_5yr=hsav if year/5==int(year/5)
gen hsav_10yr=hsav if year/10==int(year/10)
for any 10 1: replace top=l.sX \ reg hsav top gdp l.gdp dep_rat l.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - annual (OLS)")
for any 10 1: replace top=l5.sX \ reg hsav_5yr top gdp l5.gdp dep_rat l5.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 5 year blocks (OLS)")
for any 10 1: replace top=l10.sX \ reg hsav_10yr top gdp l10.gdp dep_rat l10.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 10 year blocks (OLS)")
for any 10 1: replace top=l.sX \ xi: areg hsav top gdp l.gdp dep_rat l.dep_rat i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - annual")
for any 10 1: replace top=l5.sX \ xi: areg hsav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 5 year blocks")
for any 10 1: replace top=l10.sX \ xi: areg hsav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 10 year blocks")
for any 10 1: replace top=l.sX \ xi: areg hsav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - annual. Bond control")
for any 10 1: replace top=l5.sX \ xi: areg hsav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 5 year blocks. Bond control")
for any 10 1: replace top=l10.sX \ xi: areg hsav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid , a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("HH SX - 10 year blocks. Bond control")
* Standard deviation of key variables in the {Panel C, Column 1} specification
for any 10 : replace top=l.sX \ xi: areg hsav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid , a(year) r cl(countryid) 
sum top hsav year if e(sample)

* Using LIS inequality
for any lis_5010 lis_9050: replace top=l.X \ reg sav top gdp l.gdp dep_rat l.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - annual 1960+ (OLS)")
for any lis_5010 lis_9050: replace top=l5.X \ reg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 5 year blocks 1960+ (OLS)")
for any lis_5010 lis_9050: replace top=l10.X \ reg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat if year>=1960, r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 10 year blocks 1960+ (OLS)")
for any lis_5010 lis_9050: replace top=l.X \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - annual. 1960+")
for any lis_5010 lis_9050: replace top=l5.X \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 5 year blocks. 1960+")
*for any lis_5010 lis_9050: replace top=l10.X \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 10 year blocks. 1960+")
for any lis_5010 lis_9050: replace top=l.X \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat bonds l.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - annual. Bond control. 1960+")
for any lis_5010 lis_9050: replace top=l5.X \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 5 year blocks. Bond control. 1960+")
*for any lis_5010 lis_9050: replace top=l10.X \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid if year>=1960, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("X - 10 year blocks. Bond control. 1960+")

* Splitting the sample into Anglo and non-Anglo
gen anglo=0
replace anglo=1 if country=="Australia" | country=="Canada" | country=="Ireland" | country=="UK" | country=="US"
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat i.countryid if anglo==1, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Anglo. SX - annual. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid if anglo==1, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Anglo. SX - 5 year blocks. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid if anglo==1, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Anglo. SX - 10 year blocks. 1960+")
for any 10 1: replace top=l.sX \ xi: areg sav top gdp l.gdp dep_rat l.dep_rat i.countryid if anglo==0, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Non-Anglo. SX - annual. 1960+")
for any 10 1: replace top=l5.sX \ xi: areg sav_5yr top gdp l5.gdp dep_rat l5.dep_rat i.countryid if anglo==0, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Non-Anglo. SX - 5 year blocks. 1960+")
for any 10 1: replace top=l10.sX \ xi: areg sav_10yr top gdp l10.gdp dep_rat l10.dep_rat i.countryid if anglo==0, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("Non-Anglo. SX - 10 year blocks. 1960+")

* Using all 5-year and 10-year lags
for any 10 1: replace top=l5.sX \ reg sav top gdp l5.gdp dep_rat l5.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 5 year blocks (OLS)")
for any 10 1: replace top=l10.sX \ reg sav top gdp l10.gdp dep_rat l10.dep_rat , r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 10 year blocks (OLS)")
for any 10 1: replace top=l5.sX \ xi: areg sav top gdp l5.gdp dep_rat l5.dep_rat i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 5 year blocks")
for any 10 1: replace top=l10.sX \ xi: areg sav top gdp l10.gdp dep_rat l10.dep_rat i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 10 year blocks")
for any 10 1: replace top=l5.sX \ xi: areg sav top gdp l5.gdp dep_rat l5.dep_rat bonds l5.bonds i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 5 year blocks. Bond control.")
for any 10 1: replace top=l10.sX \ xi: areg sav top gdp l10.gdp dep_rat l10.dep_rat bonds l10.bonds i.countryid, a(year) r cl(countryid) \ outreg using results.doc, coefastr bracket 3aster append bdec(3) se ct("SX - ALL 10 year blocks. Bond control.")
